/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef DLIST_H
#define DLIST_H
typedef void (* PFC)(const char *);

class dnode {
    friend class Dlist;
    dnode *next, *prev;
    void *body;
};

class Dlist {
    dnode *root;
    dnode *current;
    long count;
    long lpos;
    static PFC handler;
public:
    void fwd(int n = 1);
    void bkwd(int n = 1);
    static PFC set_handler(PFC handler);
    int linkbefore(void*);
    int linkafter(void*);
    void *linkout(void);
    void start(void);
    void end(void){ current = root; lpos = count; }
    void *get(void) const;
    long size(void) const { return count; }
    void cleanup(void);
    Dlist(void){ root = current = 0; lpos = count = 0; }
    ~Dlist(){ cleanup(); }
};
#endif
