/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifdef MK
#   if __GNUC__ < 2
#		if !defined(__ZTC__) && !defined(__WATCOMC__)
#		    include "expand.inc"
#		endif
#   endif
#else
#if defined(MSDOS) || defined(OS2)
#   include "expand.h"
#   include "balance.h"
#   include "include/sys/types.h"
#   include "include/sys/stat.h"
#   include "include/dir.h"
#   include "include/dos.h"
#   include "include/ctype.h"
#   include "include/malloc.h"
#   include "include/io.h"
#   include "include/stdlib.h"
#   include "include/stdio.h"
#   include "include/conio.h"
#   include "include/errno.h"
#   include "include/dirent.h"
#endif /* MSDOS */

#include "include/string.h"
#endif /* !MK */

#define OPEN '['
#define CLOSE ']'
#define RANGE '-'
#define STAR '*'
#define QUEST '?'
#define SLASH1 '/'
#define SLASH2 '\\'
#define COLON ':'
#define QUOTE '\''
#define DOLLAR '$'
#define DOSCONT '\r'
#define DOSQUOTE '"'

#if defined( MSDOS ) || defined( OS2 )

#define MAXLEN 100
#define DATA ((void *)1)
#define ISDIR (0x10)

int match(char *exp,char *arg){
    char *ex = exp, *ar = arg, last = '\0';
    int star = 0, open = 0, matched = 0, ret;

    for(;*ex; ex++)
	switch(*ex){
	    case OPEN:
		if(!*ar) return 1;
		if(star){
		    while(*ar)
			if(ret = match(ex,ar++), ret != 1)
			    return ret;
		    return 1;
		}
		if(open) goto ordinary;
		open = 1;
		break;
	    case CLOSE:
		if(!open) goto ordinary;
		return 1;
	    case STAR:
		if(open) goto ordinary;
		star = 1;
		break;
	    case QUEST:
		if(!*ar) return 1;
		if(open) goto ordinary;
		ar++;
		break;
	    ordinary:
	    default:
		if(!*ar) return 1;
		if(open){
		    if(*ex == RANGE)
			if(open == 1){
			    open++;
			    if(*ar != RANGE) break;
			}else if(!*++ex) return -1;	/* No close */
			else if(*ex == CLOSE){
			    if(*ar != RANGE) return 1;
			    open = 0;
			    ar++;
			    break;
			}else if(*ex < last) break;	/* reverse range ? */
			else if(*ar > last && *ar <= *ex)
			    matched = 1;	/* Find CLOSE */
		    open = 2;
		    last = *ex;
		    if(matched || *ex == *ar){
			ar++;
			matched = 0;
			if(ex = strchr(ex,CLOSE), !ex)
			    return -1;	/* No close */
			/* Now at CLOSE - ok to continue */
			open = 0;
			break;
		    }
		}else if(star){
		     while(ar = strchr(ar,*ex), ar)
			if(ret = match(ex+1,++ar), ret != 1)
			    return ret;
		     return 1;
		}else if(*ex == *ar) ar++;
		else return 1;
	}
    if(open) return -1;		/* No close */
    if(star || !*ar) return 0;
    return 1;
}

char esc(void){
    static char esc = -1;
    if(esc == -1){
	char *e = getenv("ESC");
	esc = e ? *e : '^';
    }
    return esc;
}

static void lower(char *s){
    char *p;
    for(p = s; *p; p++) if(isupper(*p)) *p = tolower(*p);
}

typedef struct {
    char **argv, **margv;
    int malloc, mmalloc, margc, argc;
} args;

static int args_init(args *t){
    t->argc = t->margc = t->mmalloc = 0;
    t->margv = 0;
    t->malloc = 5;
    if(t->argv = (char **)mem_malloc(5 * sizeof(char *)), t->argv) return 1;
    return 0;
}

static int args_free(args *t){
    int f;
    if(t->argv){
	for(f = 0; f < t->argc; f++) mem_free((void *)t->argv[f]);
	mem_free((void *)t->argv);
	t->argv = 0;
	t->argc = t->malloc = 0;
    }
    if(t->margv){
	for(f = 0; f < t->margc; f++)
	    mem_free((void *)t->margv[f]);
	mem_free((void *)t->margv);
	t->margv = 0;
	t->margc = t->mmalloc = 0;
    }
    return 0;
}

static void args_use(args *t){
    char **tmp;
    if(t->margv){
	int f;
	for(f = 0; f < t->margc; f++)
	    mem_free((void *)t->margv[f]);
	mem_free((void *)t->margv);
	t->margv = 0;
	t->margc = t->mmalloc = 0;
    }
    if(t->argc == t->malloc) return;
    tmp = (char **)mem_realloc((void *)t->argv,(size_t)t->argc*sizeof(char *));
    if(!tmp) return;
    t->argv = tmp;
    t->malloc = t->argc;
}

static int args_add(args *t,char *arg,int len){
    if(t->argc == t->malloc){
	char **tmp;
	if(!t->malloc) return 0;
	t->malloc += 5;
	tmp = (char **)mem_realloc((void *)t->argv,(size_t)t->malloc
			       * sizeof(char *));
	if(!t->argv){ t->malloc -= 5; return args_free(t); }
	t->argv = tmp;
    }
    if(t->argv[t->argc] = (char *)mem_malloc(len+1), !t->argv[t->argc])
	return args_free(t);
    memcpy(t->argv[t->argc],arg,len);
    t->argv[t->argc++][len] = 0;
    return 1;
}

static int args_madd(args *t,char *arg,int len){
    if(t->margc == t->mmalloc){
	char **tmp;
	t->mmalloc += 5;
	if(t->mmalloc == 5)
	    tmp = (char **)mem_malloc((size_t)t->mmalloc * sizeof(char *));
	else
	    tmp = (char **)mem_realloc((void *)t->margv,(size_t)t->mmalloc
				   * sizeof(char *));
	if(!tmp){ t->mmalloc -= 5; return args_free(t); }
	t->margv = tmp;
    }
    if(t->margv[t->margc] = (char *)mem_malloc(len+1), !t->margv[t->margc])
	return args_free(t);
    memcpy(t->margv[t->margc],arg,len);
    t->margv[t->margc++][len] = 0;
    return 1;
}

static void free_tree(_balanced_tree *t){
    const void *v;
    baltree_first(t);
    while(v = baltree_next(t), v) mem_free((void *)baltree_del(t,v,MAXLEN));
    baltree_destroy(t);
}

static int dostat(char *file,struct stat *st){
    if(!strcmp(file,"..") || !strcmp(file,".")){
	st->st_mode = S_IFDIR;
	return 0;
    }
    if(file[0] && file[1] == ':' && !file[2]){
	st->st_mode = S_IFDIR;
	return 0;
    }
    return stat(file,st);
}

static int getndrives(void){
    static char drive[4] = " :/";
    static int ndrives = 0;
    if(!ndrives)
	for(ndrives = 2; ; ndrives++){
	    drive[0] = 'a' + ndrives;
	    if(access(drive,0)) break;
	}
    return ndrives;
}

static int args_add_expr(args *t,char *Oexpr){
    _balanced_tree tree;
    char *tmp, *ntmp, expr[MAXLEN], ch = '\0', *before, drv[3];
    int f = -1, wild = 0, len, sl = -1, drive = 0, ndrives;
    struct stat st;
#if defined(__ZTC__) || defined(__WATCOMC__)
    struct find_t Info, *info = &Info;
#   define findfirst(a,b,c) _dos_findfirst((a),(c),(b))
#   define findnext _dos_findnext
#   define ff_name name
#   define ff_attrib attrib
#else
#ifdef OS2
    DIR *Dir;
    struct dirent *info;
#   define ff_name d_name
#   define ff_attrib d_attr
#else
    struct ffblk Info, *info = &Info;	/* for findfirst / findnext */
#endif
#endif

    if(*Oexpr == '\0')
	return args_add(t,Oexpr,strlen(Oexpr));
    baltree_construct(&tree,0);
    strcpy(expr,Oexpr);
    lower(expr);

    while(f == -1 || expr[f])
	switch(expr[++f]){
	    case OPEN:
	    case STAR:
	    case QUEST:
		wild = 1;
		break;
	    case COLON:
		if(drive || sl != -1) break;
		if(!wild){
		    if(f != 1) break;
		    sl = drive = f;
		    if(tmp = (char *)mem_malloc(MAXLEN), !tmp) return args_free(t);
		    tmp[0] = expr[0]; tmp[1] = ':'; tmp[2] = '\0';
		    baltree_insert(&tree,tmp,MAXLEN,tmp);
		    sl = drive = f;
		    break;
		}
		/* Deal with wild cards such as '*:\*'			*/
		ndrives = getndrives();
		drv[1] = ':';
		drv[2] = '\0';
		ch = expr[f+1];
		expr[f+1] = '\0';
		for(drive = 2; drive < ndrives; drive++){
		    drv[0] = 'a' + drive;
		    switch(match(expr,drv)){
			case -1:
			    free_tree(&tree);
			    expr[f+1] = ch;
			    return args_add(t,Oexpr,strlen(Oexpr));
			case 0:
			    if(tmp = (char *)mem_malloc(MAXLEN), !tmp){
				free_tree(&tree);
				return args_free(t);
			    }
			    tmp[0] = drv[0];
			    tmp[1] = ':';
			    tmp[2] = '\0';
			    baltree_insert(&tree,tmp,MAXLEN,tmp);
			    break;
		    }
		}
		expr[f+1] = ch;
		ch = '\0';
		baltree_first(&tree);
		if(!baltree_next(&tree)){
		    baltree_destroy(&tree);
		    return args_add(t,Oexpr,strlen(Oexpr));
		}
		sl = drive = f;
		wild = 0;
		break;
	    case SLASH1:
	    case SLASH2:
	    case '\0':
		if(!wild){		/* append from 'sl' to each path */
		    if(sl == -1){	/* first entry */
			if(tmp = (char *)mem_malloc(MAXLEN), !tmp){
			    free_tree(&tree);
			    return args_free(t);
			}
			if(f) memcpy(tmp,expr,f);
			tmp[f] = '\0';
			if(f && (dostat(tmp,&st) ||
				 (expr[f] && !(st.st_mode&S_IFDIR)))){
			    free_tree(&tree);
			    return args_add(t,Oexpr,strlen(Oexpr));
			}
			baltree_insert(&tree,tmp,MAXLEN,tmp);
		    }else{
			baltree_first(&tree);
			while(tmp = (char *)baltree_next(&tree), tmp){
			    len = strlen(tmp);
			    if(!drive || f != sl + 1 || drive != sl){
				if(!drive || drive != sl) tmp[len++] = SLASH2;
				memcpy(tmp+len,expr + sl+1,f - sl - 1);
				tmp[len + f - sl - 1] = '\0';
				if(dostat(tmp,&st) ||
				   (expr[f] && !(st.st_mode&S_IFDIR)))
				    mem_free((void *)baltree_del(&tree,tmp,MAXLEN));
			    }
			}
			baltree_first(&tree);
			if(!baltree_next(&tree)){
			    baltree_destroy(&tree);
			    return args_add(t,Oexpr,strlen(Oexpr));
			}
		    }
		    sl = f;
		    wild = 0;
		    break;
		}
		if(sl == -1){		/* first entry / entries */
#ifdef OS2
		    if( Dir = opendir( "." ), !Dir
			|| ( info = readdir( Dir ), !info ) )
#else
		    if(findfirst("*.*",info,ISDIR))
#endif
		    {
			free_tree(&tree);
#ifdef OS2
			if( Dir ) closedir( Dir );
#endif
			return args_add(t,Oexpr,strlen(Oexpr));
		    }
		    if(expr[f]){
			ch = expr[f];
			expr[f] = '\0';
		    }
		    do{
			if(info->ff_name[0] == '.') continue;
			if(ch && info->ff_attrib != ISDIR) continue;
			lower(info->ff_name);
			switch(match(expr,info->ff_name)){
			    case -1:
				free_tree(&tree);
				if(ch) expr[f] = ch;
#ifdef OS2
				closedir( Dir );
#endif
				return args_add(t,Oexpr,strlen(Oexpr));
			    case 0:
				if(ntmp = (char *)mem_malloc(MAXLEN), !ntmp){
				    free_tree(&tree);
				    if(ch) expr[f] = ch;
#ifdef OS2
				    closedir( Dir );
#endif
				    return args_free(t);
				}
				strcpy(ntmp,info->ff_name);
				baltree_insert(&tree,ntmp,MAXLEN,ntmp);
			}
		    }
#ifdef OS2
		    while( info = readdir( Dir ), info );
		    closedir( Dir );
#else
		    while(!findnext(&info));
#endif
		    if(ch){ expr[f] = ch; ch = '\0'; }
		}else{			/* expand all entries (duplicating) */
		    baltree_first(&tree);
		    while(tmp = (char *)baltree_next(&tree), tmp){
			baltree_del(&tree,tmp,MAXLEN);
			before = (char *)baltree_next(&tree);
			len = strlen(tmp);
#ifdef OS2
			if( Dir = opendir( tmp ), !Dir
			    || ( info = readdir( Dir ), !info ) )
#else
			if(!drive || drive != sl) strcpy(tmp+len,"/*.*");
			else strcpy(tmp+len,"*.*");
			if(findfirst(tmp,info,ISDIR))
#endif
			{
			    mem_free((void *)tmp);
			    if(before) baltree_setbefore(&tree,before,MAXLEN);
			    else baltree_last(&tree);
#ifdef OS2
			    if( Dir ) closedir( Dir );
#endif
			    continue;
			}
			tmp[len] = '\0';
			if(expr[f]){
			    ch = expr[f];
			    expr[f] = '\0';
			}
			do{
			    if(info->ff_name[0] == '.') continue;
			    if(ch && info->ff_attrib != ISDIR) continue;
			    lower(info->ff_name);
			    switch(match(expr + sl + 1,info->ff_name)){
				case -1:
				    mem_free((void *)tmp);
				    free_tree(&tree);
				    if(ch) expr[f] = ch;
				    return args_add(t,Oexpr,strlen(Oexpr));
				case 0:
				    if(ntmp = (char *)mem_malloc(MAXLEN), !ntmp){
					mem_free((void *)tmp);
					free_tree(&tree);
					if(ch) expr[f] = ch;
					return args_free(t);
				    }
				    strcpy(ntmp,tmp);
				    if(!drive || drive != sl){
					ntmp[len] = SLASH2;
					strcpy(ntmp+len+1,info->ff_name);
				    }else strcpy(ntmp+len,info->ff_name);
				    baltree_insert(&tree,ntmp,MAXLEN,ntmp);
			    }
			}
#ifdef OS2
			while( info = readdir( Dir ), info );
			closedir( Dir );
#else
			while(!findnext(&info));
#endif
			if(ch){ expr[f] = ch; ch = '\0'; }
			mem_free((void *)tmp);
			if(before) baltree_setbefore(&tree,before,MAXLEN);
			else baltree_last(&tree);
		    }
		}
		if(sl != -1 || !expr[f]){
		    baltree_first(&tree);
		    if(!baltree_next(&tree)){
			baltree_destroy(&tree);
			return args_add(t,Oexpr,strlen(Oexpr));
		    }
		}
		sl = f;
		wild = 0;
	}
    baltree_first(&tree);
    while(tmp = (char *)baltree_next(&tree), tmp){
	args_add(t,tmp,strlen(tmp));
	mem_free((void *)baltree_del(&tree,tmp,MAXLEN));
    }
    baltree_destroy(&tree);
    return 1;
}

/*	DOS treats the '"' character rather strangely.			*/
/*	If "" is found, the arg is ignored.				*/
/*	If "...."x is found, the x is seperated into another arg	*/
/*	Spaces imbedded between a '"' pair are included in the one arg	*/
/*	If there are an uneven number of occurances of '"', a \r is	*/
/*	put at the end of the line.					*/
/*	args_more() mimics this.  If dosquote is set, the previous line	*/
/*	ended with a '\r'.						*/

char *ps2(void){
    static char *ret = 0;
    static char buf[20];
    if(!ret){
	if(ret = getenv("PS2"), !ret) ret = "> ";
	strncpy(buf,ret,20);
	buf[19] = '\0';
    }
    return buf;
}

static int args_more(args *t,int dosquote){
    int f, ch, len = 20, pos = 0, lastch = 0;
    char *buf = (char *)mem_malloc((size_t)len);
    if(!buf) return args_free(t);
    if(t->margv){
	for(f = 0; f < t->margc; f++)
	    mem_free((void *)t->margv[f]);
	mem_free((void *)t->margv);
	t->margv = 0;
	t->margc = t->mmalloc = 0;
    }
    fputs(ps2(),stdout);
    fflush(stdout);
    while(ch = getchar(), ch != EOF && ch != 4){
	switch(ch){
	    case '\r':
	    case '\n':
		if(pos && !args_madd(t,buf,pos)){ mem_free((void *)buf); return 0; }
		mem_free((void *)buf);
		return 1;
	    case ' ':
	    case '\t':
		if(pos && !args_madd(t,buf,pos)){ mem_free((void *)buf); return 0; }
		pos = 0;
		break;
	    default:
		if(ch == '"'){
		    dosquote = !dosquote;
		    if(pos && ch == lastch)
			if(!dosquote){
			    pos--;
			    break;
			}else{
			    if(pos && !args_madd(t,buf,pos)){
				mem_free((void *)buf);
				return 0;
			    }
			    pos = 0;
			}
		}
		buf[pos++] = ch;
		if(pos == len){
		    len += 10;
		    if(buf = (char *)mem_realloc(buf,len), !buf)
			return args_free(t);
		}
	}
	lastch = ch;
    }
    mem_free((void *)buf);
    return 0;
}

static int oldargc;
static char **oldargv;
static args the_args;

int expand(int *cp,char ***vp){
    char *from, *to, *buf, **argv = *vp, *tmp;
    int arg, inquotes = 0, wild = 0, escape = 0, buflen = 0;
    int argc = *cp, bufsize = 100, dosquote = 0;

    if(!argc) return 0;
    if(!args_init(&the_args)){ errno = ENOMEM; return 0; }

    if(from = strrchr(*argv,'\\'), from) from++;
    else from = *argv;
    if(to = strrchr(from,'.'), !to) to = from + strlen(from);
    if(!args_add(&the_args,from,to - from)){ errno = ENOMEM; return 0; }
    lower(the_args.argv[the_args.argc - 1]);

    buf = (char *)mem_malloc(bufsize + 1);
    for(arg = 1; arg < argc; arg++){
	for(from = argv[arg]; *from; from++)
	    if(!escape && !dosquote && !inquotes && *from == esc()){
		escape = 1;
		continue;
	    }else switch(*from){
		case QUOTE:
		    if(escape) goto Default;
		    inquotes = inquotes ? 0 : 1;
		    break;
		case DOSCONT:
		case DOSQUOTE:
		    dosquote = dosquote ? 0 : 1;
		    escape = 0;
		    break;
		case DOLLAR:
		    if(escape || inquotes || *(from+1) == '\0') goto Default;
		    if(*++from == '{'){
			
		    }else if((*from > 'a' && *from < 'z') ||
			     (*from > 'A' && *from < 'Z') ||
			     *from == '_'){

		    }
		    from--;
		    goto Default;
		case OPEN:
		case STAR:
		case QUEST:
		    if(escape) wild = -1;
		    if(!dosquote && !inquotes && !escape && !wild) wild = 1;
		default:
		Default:
		    escape = 0;
		    buf[buflen++] = *from;
		    if(buflen == bufsize){
			bufsize += 50;
			if(tmp = (char *)mem_realloc(buf,bufsize + 1), !tmp){
			    mem_free((void *)buf);
			    errno = ENOMEM;
			    return args_free(&the_args);
			}
			buf = tmp;
		    }
	    }

	if(escape || dosquote || inquotes){
	    if(arg + 1 == argc && !escape) buf[buflen++] = '\n';
	    else if(!escape) buf[buflen++] = ' ';
	    escape = 0;
	    if(buflen == bufsize){
		bufsize += 50;
		if(tmp = (char *)mem_realloc(buf,bufsize + 1), !tmp){
		    mem_free((void *)buf);
		    errno = ENOMEM;
		    return args_free(&the_args);
		}
		buf = tmp;
	    }
	    if(arg + 1 == argc){
		if(!args_more(&the_args,dosquote)){
		    mem_free((void *)buf);
		    errno = 0;
		    return 0;
		}
		if(!the_args.margc && !args_madd(&the_args,"\n",1)){
		    mem_free((void *)buf);
		    errno = ENOMEM;
		    return 0;
		}
		argv = the_args.margv;
		argc = the_args.margc;
		arg = -1;
	    }
	}else{
	    buf[buflen] = '\0';
	    if(wild == 1){
		if(!args_add_expr(&the_args,buf)){
		    mem_free((void *)buf);
		    errno = ENOMEM;
		    return 0;
		}
	    }else
		if(!args_add(&the_args,buf,strlen(buf))){
		    mem_free((void *)buf);
		    errno = ENOMEM;
		    return 0;
		}
	    buflen = 0;
	    wild = 0;
	}
    }

    mem_free((void *)buf);
    args_use(&the_args);
    oldargc = *cp;
    oldargv = *vp;
    *cp = the_args.argc;
    *vp = the_args.argv;
    errno = 0;
    return 1;
}

void unexpand(int *cp,char ***vp){
    if(oldargc){
	args_free(&the_args);
	*cp = oldargc;
	*vp = oldargv;
    }
}
#endif
