/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "progname.inc"
#	endif
#   endif
#else
#   include "include/string.h"
#   include "include/ctype.h"
#   include "include/malloc.h"
#endif

extern void *malloc(size_t);

char *progname(char *argv0){
    char *ptr = strrchr(argv0,'/');
    char *ptr1 = strrchr(argv0,'\\');
    if(ptr < ptr1) ptr = ptr1;
    if(ptr) argv0 = ptr + 1;
    ptr = strrchr(argv0,'.');
    if(!ptr) ptr = argv0 + strlen(argv0);
    /* Don't use mem_malloc - we never free this pointer ! */
    if(ptr1 = (char *)malloc(ptr - argv0 + 1), !ptr1) return argv0;
    strncpy(ptr1,argv0,ptr - argv0);
    ptr1[ptr - argv0] = '\0';
    for(ptr = ptr1; *ptr; ptr++) if(isupper(*ptr)) *ptr = tolower(*ptr);
    return ptr1;
}
