/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef SIGNALS_H
#define SIGNALS_H

#ifndef MK
#   include "include/signal.h"
#   include "include/setjmp.h"
#endif

// Objects of this class MUST be nested in scope ! - This class's purpose
// is to allow signal handling to be nested.
// If signals objects were not nested, they would restore incorrect handlers.
// If they are destroyed in un-nested order, an abort() will be called.

enum active_handler { SAVE_HANDL, JMP_HANDL, USER_FN_HANDL, USER_STACK_HANDL };

class signals {
    Sig_Handler_Return (*user_fn)(int);
    Sig_Handler_Return (*user_stack)(int);
    jmp_buf *user_jmpbuf;
    int user_save;
    int maxsig, isactive;
    int *caused;
    int *handling;
    Sig_Handler_Return (**previous_handler)(int);
    void uncause(void);
    void call_oldhandler(int sig);
    static signals **declared;
    static int ndeclared, maxdeclared;
    static signals *active(int sig,active_handler type);
#ifdef DEBUG
public:
#endif
    static Sig_Handler_Return save_handler(int);
    static Sig_Handler_Return jmp_handler(int);
    static Sig_Handler_Return user_fn_handler(int);
    static Sig_Handler_Return user_stack_handler(int);
public:
    signals(int,...);
    void stack(Sig_Handler_Return (*)(int));
    void save(Sig_Handler_Return (*)(int));
    void save(jmp_buf *);
    void save();
    void restore(void);
    int cause(void);
    ~signals();
};
#endif /* SIGNALS_H */
