//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "sigtest.inc"
#	endif
#   endif
#else
#   include "common/signals.h"
#   include "include/stdio.h"
#   include "include/unistd.h"
#endif

#ifndef MSDOS
volatile int happened;

volatile int received[100];

Sig_Handler_Return user_fn(int sig){
	fprintf( stderr, "user_fn: received sig %d\n", sig );
    received[sig]++;
    happened++;
}

volatile int stacks[100];

Sig_Handler_Return stack(int sig){
	fprintf( stderr, "stack: received sig %d\n", sig );
    stacks[sig]++;
    happened++;
}

int test(){
    int ret = 0;
    signal(SIGTERM,SIG_IGN);
    signals sig0(SIGHUP,SIGINT,SIGQUIT,SIGTERM,0);
	fprintf( stderr, "Testing save(Sig_Handler_Return (*)(int))\n" );
    sig0.save(user_fn);
    signals sig1(SIGHUP,SIGINT,SIGQUIT,SIGTERM,0);
	fprintf( stderr, "Testing save(void)\n" );
    sig1.save();
    kill(getpid(),SIGTERM);
    signals sig2(SIGHUP,0);
    fprintf( stderr, "Testing stack\n" );
    sig2.stack(stack);
    kill(getpid(),SIGHUP);
    if(stacks[SIGHUP] != 1){ fprintf( stderr, "Stack failed\n" ); ret++; }
    sig2.restore();
    fprintf( stderr, "Causing... nothing should happen\n" );
    happened = 0;
    sig2.cause();
    if(happened){ fprintf( stderr, "Something happened\n" ); ret++; }
    sig1.restore();
    fprintf( stderr, "Causing... %d and %d should happen\n", SIGHUP, SIGTERM );
    happened = 0;
    sig1.cause();
    if(received[SIGHUP] != 1 || received[SIGTERM] != 1 || happened != 2){
	fprintf( stderr, "Failed\n" );
	ret++;
    }
    sig0.restore();
    fprintf( stderr, "Checking that TERM is still ignored\n" );
    happened = 0;
    kill(getpid(),SIGTERM);
    if(happened){ fprintf( stderr, "Something happened\n" ); ret++; }
    return ret;
}

main(){
	fprintf( stderr, "Call test\n" );
    int ret = test();
	fprintf( stderr, "Done test\n" );
    if(signal(SIGTERM,SIG_DFL) != SIG_IGN)
		fprintf( stderr, "SIGTERM shagged\n" );
    if(signal(SIGHUP,SIG_DFL) != SIG_DFL)
		fprintf( stderr, "SIGHUP shagged\n" );
    if(signal(SIGINT,SIG_DFL) != SIG_DFL)
		fprintf( stderr, "SIGINT shagged\n" );
    if(signal(SIGQUIT,SIG_DFL) != SIG_DFL)
		fprintf( stderr, "SIGQUIT shagged\n" );
    return ret;
}

#else /* MSDOS */
int main(){ fprintf( stderr, "Cannot test signals under MSDOS\n" ); return 0; }
#endif
