//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "stest.inc"
#	endif
#   endif
#else
#   include "common/string.h"
#   include "include/stdio.h"
#   include "include/fcntl.h"
#   ifdef MSDOS
#	include "include/io.h"
#   else
#	include "include/prototyp.h"
#   endif
#endif

char *cmp = "This is a string of length 29";

int main(int,char **){
    String line("This is a string of length 29");
    String test;
    int f;

    for(f = 0; f < 30; f++)
	if(cmp[f] != line[f]) fprintf( stderr, "String::operator[] failure\n" );

    if(line.len() != 29) fprintf( stderr, "String::len() failure\n" );

    if(line.chr('s') != 3 || line.chr('s',4) != 6 || line.chr('s',7) != 10)
	fprintf( stderr, "String::chr() failure\n" );

    if(line.rchr('s') != 10)
	fprintf( stderr, "String::rchr() failure 1\n" );
    if(line.rchr('s',9) != 6)
	fprintf( stderr, "String::rchr() failure 2\n" );
    if(line.rchr('s',10) != 10)
	fprintf( stderr, "String::rchr() failure 3\n" );
    if(line.rchr('s',2) != BAD_SIZE_T)
	fprintf( stderr, "String::rchr() failure 4\n" );

    test = "Before line";
    if(line.cmp(test) <= 0) fprintf( stderr, "String::cmp() failure\n" );

    if(line == test) fprintf( stderr, "String::operator== failure\n" );

    test = line;
    if(line.ncmp(test,29)) fprintf( stderr, "String::ncmp() failure\n" );

    if(line != test) fprintf( stderr, "String::operator!= failure\n" );

    test.set(6,'x');
    if(!line.cmp(test)) fprintf( stderr, "String::cmp() failure\n" );

    if(line.ncmp(test,6)) fprintf( stderr, "String::ncmp() failure\n" );

    if(!line.ncmp(test,7)) fprintf( stderr, "String::ncmp() failure\n" );

    test = line.sub(8,26);
    if(test != "a string of length") fprintf( stderr, "String::sub() failure\n" );

    test += " 21";
    if(test != "a string of length 21") fprintf( stderr, "String::operator+= failure\n" );

    test.setlen(18);
    test.ncat((String)" 21 ",3);
    if(test != "a string of length 21") fprintf( stderr, "String::ncat() failure\n" );

    test.ncpy(line,10);
    if(test.ncmp(line,10) || !line.ncmp(test,11))
	fprintf( stderr, "String::ncmp() failure\n" );

    test = "heaps";
    test.del(2,4);
    if(test != "hes") fprintf( stderr, "String::del() failure\n" );

    test.insert(2,(String)"ll");
    if(test != "hells") fprintf( stderr, "String::insert() failure\n" );

    test.setlen(4);
    test += 'o';
    if(test != "hello") fprintf( stderr, "String::operator+=(char) failure\n" );

    if(test + " there" != "hello there")
	fprintf( stderr, "String::operator+ failure\n" );

    test.setlen(test.len()-1);
    if(strcmp(test,"hell")) fprintf( stderr, "String::operator char * failure\n" );

    // Test String::get()

    test = "This may be a string not of length 29";
    if(String::subcmp(test,11,line,7,10)) fprintf( stderr, "String::subcmp() failure\n" );

    if(!String::subcmp(test,11,line,7,11)) fprintf( stderr, "String::subcmp() failure\n" );

    int fd = open("tmp",O_WRONLY|O_CREAT,0666);
    write(fd,"This is line one\n",17);
    write(fd,"This is line two\n",17);
    close(fd);

    FILE *fp = fopen( "tmp", "r" );
    if( fp == 0 )
	perror("Failed opening \"tmp\"");
    else{
	if(!line.get(fp) || line != "This is line one")
	    fprintf( stderr, "String::get() failure 1\n" );
	if(!line.get(fp) || line != "This is line two")
	    fprintf( stderr, "String::get() failure 2\n" );
	if(line.get(fp))
	    fprintf( stderr, "String::get() failure 3 - got \"%s\"\n", (char *)line );
	fclose(fp);
	unlink("tmp");
    }

    puts( "Test complete - if no errors are shown, all is ok" );
    return 0;
}
