//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "string.inc"
#	endif
#   endif
#else
#   include "common/string.h"
#   include "include/malloc.h"
#   include "include/ctype.h"
#   ifdef MSDOS
#	include "include/mem.h"
#   else
#	include "include/memory.h"
#   endif
#endif

#if defined( MSDOS ) | defined( OS2 )
#   define SLASH '\\'
#else
#   define SLASH '/'
#endif

String::String(const char *c,size_t len){
    if(this->ch = (char *)mem_malloc(this->mall = len + 1), !this->ch)
	this->length = this->mall = 0;
    else if(c) memcpy(this->ch,c,this->length = len);
	else memset(this->ch,'\0',this->length = len);
}

String::String(size_t len){
    this->length = 0;
    if(this->ch = (char *)mem_malloc(this->mall = len + 1), !this->ch)
		this->mall = 0;
}

String::String(const String &s){
    if(this->ch = (char *)mem_malloc(this->mall = s.length + 1), !this->ch)
		this->length = this->mall = 0;
    else memcpy(this->ch,s.ch,this->length = s.length);
}

String::String(const char *s){
    size_t len = s ? strlen(s) : 0;
    if(this->ch = (char *)mem_malloc(this->mall = len + 1), !this->ch)
		this->length = this->mall = 0;
    else if(len) memcpy(this->ch,s,this->length = len);
	else this->length = 0;
}

String::~String(){
    if(this->mall) mem_free((void *)this->ch);
}

const char String::operator[](size_t i) const {
    if(i < this->length) return this->ch[i];
    return '\0';
}

void String::assign(const char *c,size_t len){
    if(this->setlen(len) == len)
		if(c) memcpy(this->ch,c,len);
		else memset(this->ch,'\0',len);
}

size_t String::chr(char c,size_t start) const {
    if(start >= this->length) return BAD_SIZE_T;
    char *ptr = (char *)memchr(this->ch + start,c,this->length - start);
    if(!ptr) return BAD_SIZE_T;
    return ptr - this->ch;
}

size_t String::rchr(char c,size_t len) const {
    if(!this->length) return BAD_SIZE_T;
    if(len >= this->length) len = this->length-1;
    size_t f;
    for(f = len + 1; f > 0; f--) if(this->ch[f-1] == c) break;
    return f ? --f : BAD_SIZE_T;
}

int String::cmp(const String &s) const {
    int ret = this->length - s.length, memret;
    size_t l = this->length;
    if(l > s.length) l = s.length;
    if(memret = memcmp(this->ch,s.ch,l), !memret) memret = ret;
    if(memret) memret = memret < 0 ? -1 : 1;
    return memret;
}

int String::ncmp(const String &s,size_t i) const {
    int ret = 0, memret;
    size_t oi = i;
    if(i > s.length){ ret = 1; i = s.length; }
    if(i > this->length){ ret = -1; i = this->length; }
    else if(ret == 1 && oi > this->length) ret = 0;
    if(memret = memcmp(this->ch,s.ch,i), !memret) return ret;
    return memret < 0 ? -1 : 1;
}

int String::operator==(const char *s) const { return cmp((String)s) ? 0 : 1; }
int String::operator!=(const char *s) const { return cmp((String)s) ? 1 : 0; }

String String::sub(size_t start,size_t end) const {
    if(end > this->length) end = this->length;
    if(start >= end) return "";
    size_t i = end - start;
    String ret(i);
    if(ret.setlen(i) == i) memcpy(ret.ch,this->ch + start,i);
    return ret;
}

String &String::cpy(const String &s){
    if(this == &s) return *this;
    if(this->setlen(s.length) == s.length) memcpy(this->ch,s.ch,s.length);
    return *this;
}

String &String::ncpy(const String &s,size_t l){
    if(this == &s){ this->setlen(l); return *this; }
    if(l > s.length) l = s.length;
    if(this->setlen(l) == l) memcpy(this->ch,s.ch,l);
    return *this;
}

String &String::cat(const String &s){
    size_t ol = this->length, l = ol + s.length;
    if(this->setlen(l) == l) memcpy(this->ch + ol,s.ch,s.length);
    return *this;
}

String &String::operator+=(char c){
    this->set(this->length,c);
    return *this;
}

String &String::ncat(const String &s,size_t i){
    if(i > s.length) i = s.length;
    size_t ol = this->length, l = ol + i;
    if(this->setlen(l) == l) memcpy(this->ch + ol,s.ch,i);
    return *this;
}

String &String::del(size_t start,size_t end){
    if(end > this->length) end = this->length;
    if(start >= end) return *this;
    size_t diff = end - start;
    for(size_t f = end; f < this->length; f++) this->ch[f-diff] = this->ch[f];
    this->length -= diff;
    return *this;
}

String &String::insert(size_t pos,const String &s,size_t start,size_t end){
    if(!(end|start)) end = s.length;
    if(start >= end || pos > this->length) return *this;
    size_t slen = end - start, len = this->length;
    if(!this->setlen(this->length + slen)) return *this;
    if(pos < len)
		if(slen >= len)
			memcpy(this->ch + slen + pos,this->ch + pos,len - pos);
		else
			for(size_t f = len; f-- > pos;)
				this->ch[f+slen] = this->ch[f];
    memcpy(this->ch + pos,s.ch + start,slen);
    return *this;
}

String String::operator+(const char *s){
    String ret(*this);
    return ret.cat(s);
}

String String::operator+(const String &s){
    String ret(*this);
    return ret.cat(s);
}

String::operator char *(void) const {
    if(this->ch && this->ch[this->length]) this->ch[this->length] = 0;
    return this->ch ? this->ch : "";
}

size_t String::setlen(size_t l){
    this->length = l;
    if(l >= this->mall){
		// Allow for loops that repeatedly append characters
		size_t Inc = l - this->mall > 10 ? 1 : l / 4 + 5;
		if(this->ch = (char *)mem_realloc(this->ch,this->mall = l + Inc),
		   !this->ch)
			this->length = this->mall = 0;
	}
    return this->length;
}

void String::set(size_t pos,char c){
    if(pos == this->length) this->setlen(pos+1);
    if(pos < this->length) this->ch[pos] = c;
}

void String::realname(){
    size_t slash = 0, dot = 0, dotdot = 0, sl = 0, lsl = 0;
    for(size_t f = 0; f < this->length; f++){
		switch(this->ch[f]){
		case '/':
#if defined( MSDOS ) | defined( OS2 )
		case SLASH:
			if( this->ch[f] == '/' )
				this->ch[f] = SLASH;
#endif
			if(slash){
				this->del(f,f+1);
				f--;
				break;
			}else if(dot && sl == f - 2){
				this->del(sl,f);
				f = sl - 1;
				dot = 0;
				break;
			}else if(dotdot){
				this->del(lsl,f);
				sl = f = lsl;
				dotdot = 0;
				slash = 1;
				if(f && (lsl = this->rchr(SLASH,f-1),
						 lsl == BAD_SIZE_T))
					lsl = 0;
				break;
			}
			lsl = sl;
			sl = f;
			slash = 1;
			break;
		case '.': if(slash){ slash = 0; dot = 1; }
		else if(dot){ dot = 0; dotdot = 1; }
		else if(dotdot) dotdot = 0;
			break;
		default:  dot = dotdot = slash = 0;
#ifdef MSDOS
			if(isupper(this->ch[f]))
				this->ch[f] = tolower(this->ch[f]);
#endif
		}
	}
	if(dotdot) this->length = lsl;
	else if(dot) this->length = sl;
	else if(slash) this->length--;
}

void String::unpad(){
	size_t f = 0;
	while(f < this->length && (this->ch[f] == ' ' || this->ch[f] == '\t'))
		f++;
	if(f){
		for(size_t i = f; i < this->length; i++)
			this->ch[i-f] = this->ch[i];
		this->length -= f;
	}
	if(this->length){
		f = this->length - 1;
		while(this->ch[f] == ' ' || this->ch[f] == '\t') f--;
		this->length = f + 1;
	}
}

int String::get(FILE *in){
	int ch, started = 0;
	while( ch = fgetc( in ), ch != EOF ){
		if(!started){ started = 1; this->length = 0; }
		if( (char)ch == '\n' )
		{
			if( this->length && this->ch[ this->length - 1 ] == '\r' )
				this->length--;
			break;
		}
		*this += (char)ch;
	}
	if(!started) return 0;
	return 1;
}

int String::subcmp(const String &a,size_t ai,const String &b,size_t bi,
				   size_t len){
	int ret = 0, memret, olen = len;
	if(a.length < ai + len){ ret = -1; len = a.length - ai; }
	if(b.length < bi + len){ ret = 1; len = b.length - bi; }
	else if(ret == -1 && b.length < bi + olen) ret = 0;
	if(memret = memcmp(a.ch + ai,b.ch + bi,len), !memret) return ret;
	return memret < 0 ? -1 : 1;
}
