/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef STRING_H
#define STRING_H

#ifndef MK
#   include "include/string.h"
#   include "include/stdio.h"
#endif

const size_t BAD_SIZE_T = ((size_t)-1);
class String {
protected:
    char *ch;
    size_t length, mall;
public:
    String(const char *,size_t);
    String(size_t = 0);
    String(const String &);
    String(const char *);
    ~String();
    const char operator[](size_t) const;
    size_t len(void) const { return length; }
    void assign(const char *,size_t);
    size_t chr(char,size_t = 0) const;
    size_t rchr(char,size_t) const;
    size_t rchr(char c) const { return rchr(c,length-1); }
    int cmp(const String &) const;
    int ncmp(const String &,size_t) const;
    int operator==(const char *s) const;
    int operator==(const String &s) const { return cmp(s) ? 0 : 1; }
    int operator!=(const char *s) const;
    int operator!=(const String &s) const { return cmp(s) ? 1 : 0; }
    String sub(size_t start,size_t end) const;
    String &cpy(const String &);
    String &ncpy(const String &,size_t);
    String &cat(const String &);
    String &ncat(const String &,size_t);
    String &operator=(const String &s){ return cpy(s); }
    String &operator+=(const String &s){ return cat(s); }
    String &operator+=(char);
    String &del(size_t start,size_t end);
    String &insert(size_t pos,const String &s,size_t start = 0,size_t end = 0);
    String operator+(const String &);
    String operator+(const char *);
    operator char *(void) const;
    size_t setlen(size_t);
    void set(size_t,char);
    void realname(void);
    void unpad(void);
    int get(FILE *);
    static int subcmp(const String &,size_t,const String &,size_t,size_t);
};

typedef String *string_ptr;
#endif
