/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
        brian@awfulhak.demon.co.uk

*/

#ifdef __cplusplus
extern "C" {
#endif

#ifndef MK
#   include "stdlib.h"
#endif

#define MEM_NONE
/* #define MEM_DEBUG */
/* #define MEM_PARANOID */
/* #define MEM_SHOWCALLS */

#if defined( MEM_PARANOID ) && !defined( MEM_DEBUG )
#define MEM_DEBUG
#endif

#if defined( MEM_SHOWCALLS ) && !defined( MEM_DEBUG )
#define MEM_DEBUG
#endif

#if !defined( MEM_NONE ) && !defined( MEM_DEBUG )
#error "You must either define MEM_DEBUG or MEM_NONE"
#endif

enum MemBehaviour { MEM_ABORT, MEM_RETNULL, MEM_CALLFP };

#ifdef MEM_NONE

#define mem_strdup(p)	dostrdup(p)
#define mem_malloc(u)	malloc(u)
#define mem_calloc(u)	calloc((u),1)
#define mem_realloc(p,u)	realloc((p),(u))
#define mem_free(p)	free(p)
#define mem_check()	((void)0)
#define mem_checkptr(p)	((void)(p))
#define mem_new		new
#define mem_delete	delete

#else

/* Use a MemFailedAllocPtr with MEM_CALLFP !0 means retry */
typedef int ( *MemFailedAllocPtr )( void );
void MemSetBehaviour( enum MemBehaviour, ... );

#ifdef __cplusplus
	extern int __mem_line;
	extern char *__mem_file;
#	define mem_new		!(__mem_line=__LINE__,__mem_file=__FILE__)? 0 : new
#	define mem_delete	 (__mem_line=__LINE__,__mem_file=__FILE__), delete
#endif


#define mem_strdup(p) mem_strdup_debug( (p), __FILE__, __LINE__ )
#define mem_malloc(u) mem_malloc_debug( (u), __FILE__, __LINE__ )
#define mem_calloc(u) mem_calloc_debug( (u), __FILE__, __LINE__ )
#define mem_realloc(p,u) mem_realloc_debug( (p), (u), __FILE__, __LINE__ )
#define mem_free(p)	mem_free_debug( (p), __FILE__, __LINE__ )

void mem_check( void );				/* check malloc area */
int mem_checkptr( void *ptr );		/* part of allocated data ? 1 => ok */
char *mem_strdup_debug( const char *, const char *, int );
void *mem_calloc_debug( unsigned, const char *, int );
void *mem_malloc_debug( unsigned, const char *, int );
void *mem_realloc_debug( void *, unsigned, const char *, int );
void mem_free_debug( void *, const char *, int );

#endif

#ifdef __cplusplus
}
#endif
