//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "mapping.inc"
#	endif
#   endif
#else
#   include "mapping.h"
#   include "defaults.h"
#   include "include/stdio.h"
#   include "include/fcntl.h"
#   include "include/prototyp.h"
#   include "include/malloc.h"
#endif

class map {
public:
    String from;
    String to;
    map(const String &f,const String &t) : from(f), to(t) {}
};

void mapping::add(const String &from,const String &to){
    map *m = mem_new map(from,to);
    this->list.linkafter(m);
}

static String mappingBuffer;

String *mapping::Stat
	(const String &file,const String &fmt,struct stat &st,int &rev)
{
    int sz = this->list.size();
    map *m;

    this->list.end();
    for(this->list.end(); sz--; this->list.bkwd()){
		m = (map *)this->list.get();
		if(!file.ncmp(m->from,m->from.len())){
			mappingBuffer = m->to;
			mappingBuffer += (const char *)file + m->from.len();
			String MapName( mappingBuffer );
			ExpandName( MapName, fmt );
			if(stat(MapName,&st) != -1){
				rev = 0;
				return mem_new String(mappingBuffer);
			}
		}
		if(rev && !file.ncmp(m->to,m->to.len())){
			mappingBuffer = m->from;
			mappingBuffer += (const char *)file + m->to.len();
			String MapName( mappingBuffer );
			ExpandName( MapName, fmt );
			if(access(MapName,0) != -1 )
			{
				MapName = file;
				ExpandName( MapName, fmt );
				if( stat( MapName, &st ) != -1 )
					return mem_new String(mappingBuffer);
			}
		}
    }
    rev = 0;
    return 0;
}

String *mapping::AnyMap(const String &file){
    int sz = this->list.size();
    map *m;
    this->list.end();
    for(this->list.end(); sz--; this->list.bkwd()){
		m = (map *)this->list.get();
		if(!file.ncmp(m->from,m->from.len())){
			String *Result = mem_new String;
			*Result = m->to;
			*Result += (char *)file + m->from.len();
			return Result;
		}
	}
	return 0;
}


String *mapping::Open(const String &file,const String &fmt,int &fd,int &rev){
    int sz = this->list.size();
    map *m;
    this->list.end();
    for(this->list.end(); sz--; this->list.bkwd()){
		m = (map *)this->list.get();
		if(!file.ncmp(m->from,m->from.len())){
			mappingBuffer = m->to;
			mappingBuffer += (char *)file + m->from.len();
			String MapName( mappingBuffer );
			ExpandName( MapName, fmt );
			if( fd = open( MapName, O_RDONLY ), fd != -1 )
			{
				rev = 0;
				return mem_new String(mappingBuffer);
			}
		}
		if(rev && !file.ncmp(m->to,m->to.len())){
			mappingBuffer = m->from;
			mappingBuffer += (const char *)file + m->to.len();
			String MapName( mappingBuffer );
			ExpandName( MapName, fmt );
			if( access( MapName, 0 ) != -1 )
			{
				MapName = file;
				ExpandName( MapName, fmt );
				if( fd = open( MapName, O_RDONLY ), fd != -1 )
					return mem_new String(mappingBuffer);
			}
		}
    }
    rev = 0;
    return 0;
}

mapping::~mapping(){
    int sz = this->list.size();
    while(sz--) mem_delete (map *)this->list.linkout();
}
