/*
			COPYRIGHT NOTICE

	This code was originally written, and is owned by Brian Somers.
	It may be copied, altered, given away or sold by anybody who
	feels so inclined, but must at all times contain this copyright
	notice.
	brian@awfulhak.demon.co.uk

*/
#ifndef PARSE_H
#define PARSE_H

#ifndef MK
#   include "common/dlist.h"
#   include "common/balance.h"
#   include "common/string.h"
#   include "module.h"
#   include "defaults.h"
#   include "mapping.h"
#   include "allocate.h"
#   include "include/time.h"
#endif

#define MOD_ONE_COMPILE	(0x01)
#define MOD_ALL_COMPILE	(0x02)
#define MOD_LOAD	(0x04)
#define MOD_RECURSE	(0x08)
#define MOD_FORCE	(0x10)
#define MOD_VERBOSE	(0x20)
#define MOD_KEEPTMP	(0x40)
#define MOD_REMOVE	(0x80)
#define MOD_QUIET	(0x100)
#define MOD_REVERSE_LOAD	(0x200)
#define MOD_STARTING	(0x8000)

#define SOURCE_FILES (1)
#define TARGET_FILES (2)
#define TMP_FILES (4)

const time_t OUTOFDATE = (time_t)~((unsigned long)1 << (sizeof(time_t)*8-1));
enum parse_return { PARSE_OK, PARSE_FAIL, PARSE_NOMODULE };

class Parse {
    module *ReadModule(String &modname);
    String &Expand(String &, int = 0);
    int getexpline(String &);
    void getcwd(void);
    const String &Relative(const String &);
    const String &getenv(const String &);
    void putenv(char *,const char *);
    int CreateIncFile(module &,action &);
    void SetTarget(const String &,const String &,
				   const String &,const String &);
    void dontexpandtarget(void);
    int CreateRspFile( module &m, action &act, int toplev );
    void CreateRspList(module &,_balanced_tree *,Dlist &,int WantLibs);
    int CreateTargetInterface(module &,action &);
    module *getmodule(void);
	void show_inc_maps(module &,action &);
    void show_rsp_maps(action &,Dlist &);
    int mapstring(const String &,const String &,int,const char * = 0,int = 0);
    void do_malloc(char *&,String &);	// inserts to this->alloc

    allocator alloc;			// allocates strings
    default_t defaults;			// default values
    String cwd;				// Working dir
    Dlist modulelist;			// points to a module
    _balanced_tree modulexref;		// points to a module
    _balanced_tree env;			// buffered environment
    _balanced_tree ignore;		// strings of lines to ignore
    module *top_mod;
    int flags;
    mapping *map;
	int GiveUp;			// How many times to retry before giving up on a LOAD
public:
    Parse();
    Parse(const char *modname,int = MOD_ALL_COMPILE|MOD_LOAD);
    int startup( String &rcfile, int &flags );
    int set_map(const String &mapfile,int verbose);
    void rm_map(void);
    parse_return getlist(const char *modname,int = MOD_ALL_COMPILE|MOD_LOAD);
    char *getfile(void);
    void startlist(void){ this->flags |= MOD_STARTING; }
    const char *nextmodule(void);
    const char *nextfile(int = SOURCE_FILES|TARGET_FILES|TMP_FILES);
    action &getoutofdate(int &priority,const char *external = 0);
    int compile(const char *external = 0,int parallel = 1);
    void dellist(void);
	int IsLockedByMe();
    ~Parse();
};
#endif /* PARSE_H */
