//
//                      COPYRIGHT NOTICE
//
//      This code was originally written, and is owned by Brian Somers.
//      It may be copied, altered, given away or sold by anybody who
//      feels so inclined, but must at all times contain this copyright
//      notice.
//      brian@awfulhak.demon.co.uk
//
//
#ifdef MK
#   if __GNUC__ < 2
#	if !defined(__ZTC__) && !defined(__WATCOMC__)
#	    include "readfile.inc"
#	endif
#   endif
#else
#   include "readfile.h"
#   include "include/stdio.h"
#   include "include/fcntl.h"
#   include "include/sys/types.h"
#   include "include/sys/stat.h"
#   include "include/prototyp.h"
#   include "include/malloc.h"
#endif

readfile::readfile(int fd)
{
    struct stat st;

    if( fstat( fd, &st ) == -1 ) this->info = 0;
    else
	{
		this->info = mem_new char[ st.st_size + 1 ];
		this->info[ read( fd, this->info, st.st_size ) ] = '\0';
    }
    this->ptr = this->info;
}

int readfile::getline(String &line){
    if( !this->ptr ) return EOF;
    char *end = strchr( ptr, '\n' );
    int len = end ? end - ptr : strlen(ptr);
	if( ptr[ len - 1 ] == '\r' ) len--;
    line.assign( ptr, len );
    if( ptr = end, ptr ) ptr++;
    return len;
}

readfile::~readfile(){
    if( this->info ) mem_delete this->info;
}
